"""Peewee migrations -- 001_auto.py.

Some examples (model - class or model name)::

    > Model = migrator.orm['model_name']            # Return model in current state by name

    > migrator.sql(sql)                             # Run custom SQL
    > migrator.python(func, *args, **kwargs)        # Run python code
    > migrator.create_model(Model)                  # Create a model (could be used as decorator)
    > migrator.remove_model(model, cascade=True)    # Remove a model
    > migrator.add_fields(model, **fields)          # Add fields to a model
    > migrator.change_fields(model, **fields)       # Change fields
    > migrator.remove_fields(model, *field_names, cascade=True)
    > migrator.rename_field(model, old_field_name, new_field_name)
    > migrator.rename_table(model, new_table_name)
    > migrator.add_index(model, *col_names, unique=False)
    > migrator.drop_index(model, *col_names)
    > migrator.add_not_null(model, *field_names)
    > migrator.drop_not_null(model, *field_names)
    > migrator.add_default(model, field_name, default)

"""

import datetime as dt
import peewee as pw
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    @migrator.create_model
    class CsxxInfo(pw.Model):
        id = pw.CharField(max_length=255, primary_key=True)
        lp_a = pw.CharField(max_length=255, null=True)
        hcy = pw.CharField(max_length=255, null=True)
        hs_crp = pw.CharField(max_length=255, null=True)
        fbg = pw.CharField(max_length=255, null=True)
        dimer = pw.CharField(max_length=255, null=True)
        fdp = pw.CharField(max_length=255, null=True)
        a2 = pw.CharField(max_length=255, null=True)
        status = pw.CharField(constraints=[SQL("DEFAULT '1_not_match'")], default='1_not_match', max_length=255, null=True)
        create_time = pw.DateTimeField(null=True)
        update_time = pw.DateTimeField(null=True)

        class Meta:
            table_name = "csxxinfo"

    @migrator.create_model
    class RecordInfo(pw.Model):
        id = pw.CharField(max_length=255, primary_key=True)
        name = pw.CharField(max_length=255, null=True)
        gender = pw.CharField(max_length=255, null=True)
        age = pw.CharField(max_length=255, null=True)
        marriage = pw.CharField(max_length=255, null=True)
        work = pw.CharField(max_length=255, null=True)
        phone = pw.CharField(max_length=255, null=True)
        address = pw.CharField(max_length=255, null=True)
        stroke = pw.CharField(max_length=255, null=True)
        ischemic = pw.CharField(max_length=255, null=True)
        hypertension = pw.CharField(max_length=255, null=True)
        heart_disease = pw.CharField(max_length=255, null=True)
        diabetes = pw.CharField(max_length=255, null=True)
        dyslipidemia = pw.CharField(max_length=255, null=True)
        smoke_drink = pw.CharField(max_length=255, null=True)
        fat_less_exercise = pw.CharField(max_length=255, null=True)
        age_over_45 = pw.CharField(max_length=255, null=True)
        family_stroke = pw.CharField(max_length=255, null=True)
        lp_a = pw.CharField(max_length=255, null=True)
        hcy = pw.CharField(max_length=255, null=True)
        hs_crp = pw.CharField(max_length=255, null=True)
        fbg = pw.CharField(max_length=255, null=True)
        dimer = pw.CharField(max_length=255, null=True)
        fdp = pw.CharField(max_length=255, null=True)
        a2 = pw.CharField(max_length=255, null=True)
        status = pw.CharField(constraints=[SQL("DEFAULT '1_not_match'")], default='1_not_match', max_length=255, null=True)
        create_time = pw.DateTimeField(null=True)
        update_time = pw.DateTimeField(null=True)

        class Meta:
            table_name = "recordinfo"

    @migrator.create_model
    class RecordInfoHistory(pw.Model):
        id = pw.CharField(max_length=255, primary_key=True)
        name = pw.CharField(max_length=255, null=True)
        gender = pw.CharField(max_length=255, null=True)
        age = pw.CharField(max_length=255, null=True)
        marriage = pw.CharField(max_length=255, null=True)
        work = pw.CharField(max_length=255, null=True)
        phone = pw.CharField(max_length=255, null=True)
        address = pw.CharField(max_length=255, null=True)
        stroke = pw.CharField(max_length=255, null=True)
        ischemic = pw.CharField(max_length=255, null=True)
        hypertension = pw.CharField(max_length=255, null=True)
        heart_disease = pw.CharField(max_length=255, null=True)
        diabetes = pw.CharField(max_length=255, null=True)
        dyslipidemia = pw.CharField(max_length=255, null=True)
        smoke_drink = pw.CharField(max_length=255, null=True)
        fat_less_exercise = pw.CharField(max_length=255, null=True)
        age_over_45 = pw.CharField(max_length=255, null=True)
        family_stroke = pw.CharField(max_length=255, null=True)
        lp_a = pw.CharField(max_length=255, null=True)
        hcy = pw.CharField(max_length=255, null=True)
        hs_crp = pw.CharField(max_length=255, null=True)
        fbg = pw.CharField(max_length=255, null=True)
        dimer = pw.CharField(max_length=255, null=True)
        fdp = pw.CharField(max_length=255, null=True)
        a2 = pw.CharField(max_length=255, null=True)
        status = pw.CharField(constraints=[SQL("DEFAULT '1_not_match'")], default='1_not_match', max_length=255, null=True)
        create_time = pw.DateTimeField(null=True)
        update_time = pw.DateTimeField(null=True)

        class Meta:
            table_name = "recordinfohistory"



def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""

    migrator.remove_model('recordinfohistory')

    migrator.remove_model('recordinfo')

    migrator.remove_model('csxxinfo')
